<?php

declare(strict_types=1);

use Erlage\Photogram\State;
use Erlage\Photogram\Constants\ServerConstants;
use Erlage\Photogram\Constants\RequestConstants;
use Erlage\Photogram\Requests\Collection\CollectionActions;
use Erlage\Photogram\Requests\Collection\CollectionContent;

/*
|--------------------------------------------------------------------------
| Handle request:
|--------------------------------------------------------------------------
*/

switch (State::getReqType())
{
    /*
    |--------------------------------------------------------------------------
    | look for collection requests only
    |--------------------------------------------------------------------------
    */

    // content

    case RequestConstants::REQ_TYPE_COLLECTION_LOAD_LATEST:
        CollectionContent::load(ServerConstants::SERVER_CONST_LOAD_TYPE_LATEST);

    break;

    case RequestConstants::REQ_TYPE_COLLECTION_LOAD_BOTTOM:
        CollectionContent::load(ServerConstants::SERVER_CONST_LOAD_TYPE_BOTTOM);

    break;

    // actions

    case RequestConstants::REQ_TYPE_COLLECTION_ADD: CollectionActions::add();

    break;

    case RequestConstants::REQ_TYPE_COLLECTION_REMOVE: CollectionActions::remove();

    break;

    case RequestConstants::REQ_TYPE_COLLECTION_UPDATE: CollectionActions::update();

    break;
}
